<!DOCTYPE html>
<html>
<head>
    <title>Admin Panel - Test</title>
    <style>
        body { font-family: Arial; margin: 20px; }
        .status { padding: 10px; margin: 10px 0; border-radius: 5px; }
        .success { background: #d4edda; color: #155724; }
        .error { background: #f8d7da; color: #721c24; }
        .info { background: #d1ecf1; color: #0c5460; }
        pre { background: #f5f5f5; padding: 10px; overflow-x: auto; }
    </style>
</head>
<body>
    <h1>Admin Dashboard - Test Status</h1>
    
    <?php
    session_start();
    require_once 'config.php';
    
    // Check connection
    if ($conn->connect_error) {
        echo '<div class="status error">❌ Database Connection Error: ' . $conn->connect_error . '</div>';
        exit;
    }
    echo '<div class="status success">✓ Database Connected</div>';
    
    // Check if logged in
    if (!isset($_SESSION['user_id'])) {
        echo '<div class="status error">❌ Not logged in as admin</div>';
        echo '<p>Please <a href="admin-login.php">log in first</a></p>';
        exit;
    }
    
    $user_id = $_SESSION['user_id'];
    $user_type = $_SESSION['user_type'] ?? 'unknown';
    
    if ($user_type !== 'admin') {
        echo '<div class="status error">❌ Not an admin user (Type: ' . htmlspecialchars($user_type) . ')</div>';
        exit;
    }
    
    echo '<div class="status success">✓ Logged in as Admin (ID: ' . $user_id . ')</div>';
    
    // Check admin profile table
    echo '<h2>Admin Profile Check</h2>';
    $query = "SELECT id, name, email, phone, position FROM staff WHERE id = $user_id";
    $result = $conn->query($query);
    
    if ($result && $result->num_rows > 0) {
        $profile = $result->fetch_assoc();
        echo '<div class="status success">✓ Admin profile found</div>';
        echo '<pre>' . json_encode($profile, JSON_PRETTY_PRINT) . '</pre>';
    } else {
        echo '<div class="status error">❌ Admin profile not found in staff table</div>';
    }
    
    // Check staff_assignments table
    echo '<h2>Database Tables Check</h2>';
    
    $tables = ['staff_assignments', 'staff', 'users'];
    foreach ($tables as $table) {
        $result = $conn->query("SHOW TABLES LIKE '$table'");
        if ($result && $result->num_rows > 0) {
            echo "<div class=\"status success\">✓ Table '$table' exists</div>";
            // Show column count
            $descResult = $conn->query("DESCRIBE $table");
            $colCount = $descResult->num_rows;
            echo "<p style=\"margin-left: 20px; color: #666;\">Columns: $colCount</p>";
        } else {
            echo "<div class=\"status error\">❌ Table '$table' NOT found</div>";
        }
    }
    
    // Check staff members
    echo '<h2>Available Staff Members</h2>';
    $result = $conn->query("SELECT id, name, email FROM staff WHERE user_type = 'staff' LIMIT 5");
    if ($result && $result->num_rows > 0) {
        echo '<div class="status success">✓ Staff members found</div>';
        echo '<ul>';
        while ($row = $result->fetch_assoc()) {
            echo '<li>' . htmlspecialchars($row['name']) . ' (ID: ' . $row['id'] . ')</li>';
        }
        echo '</ul>';
    } else {
        echo '<div class="status error">❌ No staff members found in database</div>';
    }
    
    // Check existing assignments
    echo '<h2>Existing Task Assignments</h2>';
    $result = $conn->query("SELECT COUNT(*) as count FROM staff_assignments");
    if ($result) {
        $row = $result->fetch_assoc();
        $count = $row['count'];
        echo "<div class=\"status info\">Currently $count task assignments in database</div>";
        
        if ($count > 0) {
            $result = $conn->query("SELECT * FROM staff_assignments ORDER BY created_at DESC LIMIT 3");
            echo '<h3>Recent Assignments:</h3>';
            echo '<pre>' . json_encode($result->fetch_all(MYSQLI_ASSOC), JSON_PRETTY_PRINT) . '</pre>';
        }
    }
    
    ?>
    
    <h2>Test Form</h2>
    <p><a href="admin-dashboard.php">Go back to Admin Dashboard</a></p>
</body>
</html>
